# frozen_string_literal: true

module ControllerHelpers
  # https://github.com/plataformatec/devise/wiki/How-To:-Stub-authentication-in-controller-specs
  def sign_in_stub(user = double('user'))
    if user.nil?
      allow(request.env['warden']).to receive(:authenticate!).and_throw(:warden, {scope: :user})
      allow(controller).to receive(:current_user).and_return(nil)
    else
      allow(request.env['warden']).to receive(:authenticate!).and_return(user)
      allow(controller).to receive(:current_user).and_return(user)
    end
  end
end
