# Search Experience Wireframes

## Desktop Layout (1024px+)

### Default State - Grid View

```
┌────────────────────────────────────────────────────────────────────────────────┐
│  HEADER / NAVIGATION                                                           │
├────────────────────────────────────────────────────────────────────────────────┤
│  Home > Properties for Sale                                                    │
├────────────────────────────────────────────────────────────────────────────────┤
│                                                                                │
│  ┌─── FILTERS (w-1/4) ────────────┐  ┌─── RESULTS (w-3/4) ─────────────────┐   │
│  │                                │  │                                      │   │
│  │  ┌─ Property Type ───────────┐ │  │  ┌─ Results Header ────────────────┐ │   │
│  │  │ [▼ All Types           ]  │ │  │  │                                  │ │   │
│  │  └───────────────────────────┘ │  │  │  24 properties found              │ │   │
│  │                                │  │  │                                  │ │   │
│  │  ┌─ Price Range ─────────────┐ │  │  │  Sort: [Price: Low to High ▼]   │ │   │
│  │  │ Min: [€        ] EUR      │ │  │  │  View: [▦] [≡] [🗺]             │ │   │
│  │  │ Max: [€        ] EUR      │ │  │  │                                  │ │   │
│  │  │                           │ │  │  └──────────────────────────────────┘ │   │
│  │  │ ○────────●────────○       │ │  │                                      │   │
│  │  │ €0    €500k    €1M+       │ │  │  ┌─────────┐ ┌─────────┐ ┌─────────┐ │   │
│  │  └───────────────────────────┘ │  │  │ ┌─────┐ │ │ ┌─────┐ │ │ ┌─────┐ │ │   │
│  │                                │  │  │ │ IMG │ │ │ │ IMG │ │ │ │ IMG │ │ │   │
│  │  ┌─ Bedrooms ────────────────┐ │  │  │ └─────┘ │ │ └─────┘ │ │ └─────┘ │ │   │
│  │  │ ○ Any  ● 1+  ○ 2+  ○ 3+   │ │  │  │ Title   │ │ Title   │ │ Title   │ │   │
│  │  │ ○ 4+   ○ 5+               │ │  │  │ €350k   │ │ €420k   │ │ €510k   │ │   │
│  │  └───────────────────────────┘ │  │  │ 🛏 3 🚿 2│ │ 🛏 2 🚿 1│ │ 🛏 4 🚿 3│ │   │
│  │                                │  │  └─────────┘ └─────────┘ └─────────┘ │   │
│  │  ┌─ Bathrooms ───────────────┐ │  │                                      │   │
│  │  │ ○ Any  ● 1+  ○ 2+  ○ 3+   │ │  │  ┌─────────┐ ┌─────────┐ ┌─────────┐ │   │
│  │  └───────────────────────────┘ │  │  │ ┌─────┐ │ │ ┌─────┐ │ │ ┌─────┐ │ │   │
│  │                                │  │  │ │ IMG │ │ │ │ IMG │ │ │ │ IMG │ │ │   │
│  │  ┌─ Location ────────────────┐ │  │  │ └─────┘ │ │ └─────┘ │ │ └─────┘ │ │   │
│  │  │ Zone:     [▼ All Zones ]  │ │  │  │ Title   │ │ Title   │ │ Title   │ │   │
│  │  │ City:     [▼ All Cities]  │ │  │  │ €275k   │ │ €680k   │ │ €390k   │ │   │
│  │  └───────────────────────────┘ │  │  │ 🛏 2 🚿 1│ │ 🛏 5 🚿 4│ │ 🛏 3 🚿 2│ │   │
│  │                                │  │  └─────────┘ └─────────┘ └─────────┘ │   │
│  │  ┌─ Features ────────────────┐ │  │                                      │   │
│  │  │ ☐ Swimming Pool           │ │  │  ┌─ Pagination ─────────────────────┐│   │
│  │  │ ☐ Garden                  │ │  │  │  ← Prev  1  2  3  ...  8  Next → ││   │
│  │  │ ☐ Sea Views               │ │  │  └──────────────────────────────────┘│   │
│  │  │ ☐ Garage                  │ │  │                                      │   │
│  │  │ ☐ Air Conditioning        │ │  └──────────────────────────────────────┘   │
│  │  │ [Show more ▼]             │ │                                            │
│  │  └───────────────────────────┘ │                                            │
│  │                                │                                            │
│  │  ┌───────────────────────────┐ │                                            │
│  │  │    [Clear All Filters]    │ │                                            │
│  │  └───────────────────────────┘ │                                            │
│  │                                │                                            │
│  └────────────────────────────────┘                                            │
│                                                                                │
│  ┌─ MAP (Collapsible) ─────────────────────────────────────────────────────┐   │
│  │  [▼ Show Map]                                                            │   │
│  │  ┌──────────────────────────────────────────────────────────────────┐   │   │
│  │  │                                                                  │   │   │
│  │  │         🏠 €350k                    🏠 €420k                      │   │   │
│  │  │                           🏠 €275k                                │   │   │
│  │  │                                           🏠 €510k               │   │   │
│  │  │              🏠 €680k                                             │   │   │
│  │  │                                    🏠 €390k                       │   │   │
│  │  │                                                                  │   │   │
│  │  └──────────────────────────────────────────────────────────────────┘   │   │
│  └─────────────────────────────────────────────────────────────────────────┘   │
│                                                                                │
├────────────────────────────────────────────────────────────────────────────────┤
│  FOOTER                                                                        │
└────────────────────────────────────────────────────────────────────────────────┘
```

### Loading State

```
┌─── RESULTS (w-3/4) ─────────────────────────────────────────────────────────┐
│                                                                              │
│  ┌─ Results Header ────────────────────────────────────────────────────────┐│
│  │  ⟳ Loading...                                              Sort: [···]  ││
│  └─────────────────────────────────────────────────────────────────────────┘│
│                                                                              │
│  ┌─────────────┐ ┌─────────────┐ ┌─────────────┐                            │
│  │ ░░░░░░░░░░░ │ │ ░░░░░░░░░░░ │ │ ░░░░░░░░░░░ │  ← Skeleton cards         │
│  │ ░░░░░░░░░░░ │ │ ░░░░░░░░░░░ │ │ ░░░░░░░░░░░ │    with pulse            │
│  │ ░░░░░░░░░░░ │ │ ░░░░░░░░░░░ │ │ ░░░░░░░░░░░ │    animation             │
│  │ ░░░░░░░░░░░ │ │ ░░░░░░░░░░░ │ │ ░░░░░░░░░░░ │                          │
│  │ ░░░░░░░░░░░ │ │ ░░░░░░░░░░░ │ │ ░░░░░░░░░░░ │                          │
│  └─────────────┘ └─────────────┘ └─────────────┘                            │
│                                                                              │
│  ┌─────────────┐ ┌─────────────┐ ┌─────────────┐                            │
│  │ ░░░░░░░░░░░ │ │ ░░░░░░░░░░░ │ │ ░░░░░░░░░░░ │                          │
│  │ ░░░░░░░░░░░ │ │ ░░░░░░░░░░░ │ │ ░░░░░░░░░░░ │                          │
│  │ ░░░░░░░░░░░ │ │ ░░░░░░░░░░░ │ │ ░░░░░░░░░░░ │                          │
│  └─────────────┘ └─────────────┘ └─────────────┘                            │
│                                                                              │
└─────────────────────────────────────────────────────────────────────────────┘
```

### No Results State

```
┌─── RESULTS ─────────────────────────────────────────────────────────────────┐
│                                                                              │
│  ┌─ Results Header ────────────────────────────────────────────────────────┐│
│  │  0 properties found                                                     ││
│  └─────────────────────────────────────────────────────────────────────────┘│
│                                                                              │
│              ┌─────────────────────────────────────────┐                    │
│              │                                         │                    │
│              │            🔍                           │                    │
│              │                                         │                    │
│              │     No properties found                 │                    │
│              │                                         │                    │
│              │   Try adjusting your filters or         │                    │
│              │   searching in a different area.        │                    │
│              │                                         │                    │
│              │        [Clear All Filters]              │                    │
│              │                                         │                    │
│              └─────────────────────────────────────────┘                    │
│                                                                              │
└─────────────────────────────────────────────────────────────────────────────┘
```

---

## Mobile Layout (<768px)

### Default State - Collapsed Filters

```
┌────────────────────────────┐
│  ☰  LOGO           🔍 👤   │
├────────────────────────────┤
│  Home > Buy                 │
├────────────────────────────┤
│                            │
│  ┌────────────────────────┐│
│  │ [🔧 Filters (2)]  [🗺] ││  ← Active filter count badge
│  └────────────────────────┘│
│                            │
│  24 properties • Sort ▼    │
│                            │
│  ┌────────────────────────┐│
│  │  ┌──────────────────┐  ││
│  │  │                  │  ││
│  │  │      IMAGE       │  ││
│  │  │                  │  ││
│  │  └──────────────────┘  ││
│  │                        ││
│  │  Modern Apartment      ││
│  │  Marbella              ││
│  │                        ││
│  │  €350,000              ││
│  │  🛏 3  🚿 2  📐 120m²   ││
│  │                        ││
│  └────────────────────────┘│
│                            │
│  ┌────────────────────────┐│
│  │  ┌──────────────────┐  ││
│  │  │      IMAGE       │  ││
│  │  └──────────────────┘  ││
│  │  Luxury Villa          ││
│  │  Estepona              ││
│  │  €680,000              ││
│  │  🛏 5  🚿 4  📐 350m²   ││
│  └────────────────────────┘│
│                            │
│  ┌────────────────────────┐│
│  │      [Load More]       ││
│  └────────────────────────┘│
│                            │
├────────────────────────────┤
│  FOOTER                    │
└────────────────────────────┘
```

### Filter Panel - Slide In (Bottom Sheet)

```
┌────────────────────────────┐
│  ☰  LOGO           🔍 👤   │
├────────────────────────────┤
│░░░░░░░░░░░░░░░░░░░░░░░░░░░░│ ← Dimmed background
│░░░░░░░░░░░░░░░░░░░░░░░░░░░░│
│░░░░░░░░░░░░░░░░░░░░░░░░░░░░│
├────────────────────────────┤  ← Slide-up panel
│  ─────                     │  ← Drag handle
│                            │
│  ← Filters         Clear   │
│                            │
│  Property Type             │
│  ┌────────────────────────┐│
│  │ [▼ Apartment        ]  ││
│  └────────────────────────┘│
│                            │
│  Price Range               │
│  ○───────────●─────────○   │
│  €0        €500k      €1M+ │
│                            │
│  Bedrooms                  │
│  [ Any ] [1+] [2+] [3+]    │
│  [ 4+ ] [ 5+ ]             │
│                            │
│  Location                  │
│  ┌────────────────────────┐│
│  │ [▼ Marbella         ]  ││
│  └────────────────────────┘│
│                            │
│  Features                  │
│  ☑ Pool   ☐ Garden        │
│  ☐ Views  ☐ Garage        │
│                            │
│  ┌────────────────────────┐│
│  │  Show 24 Properties    ││
│  └────────────────────────┘│
│                            │
└────────────────────────────┘
```

### Map View (Full Screen)

```
┌────────────────────────────┐
│  ← Back         Filters 🔧 │
├────────────────────────────┤
│                            │
│                            │
│    🏠 €350k                │
│              🏠 €420k      │
│                            │
│         🏠 €275k           │
│                            │
│                  🏠 €510k  │
│    🏠 €680k                │
│                            │
│              🏠 €390k      │
│                            │
│                            │
│                            │
├────────────────────────────┤
│  ┌────────────────────────┐│ ← Property preview card
│  │ [IMG] Modern Apartment ││   (appears on marker tap)
│  │       €350k  🛏3 🚿2   ││
│  │       [View Details →] ││
│  └────────────────────────┘│
└────────────────────────────┘
```

---

## Component Details

### Property Card (Grid View)

```
┌───────────────────────────────────┐
│  ┌─────────────────────────────┐  │
│  │                             │  │
│  │                             │  │
│  │          PROPERTY           │  │
│  │           IMAGE             │  │  ← 4:3 aspect ratio
│  │                             │  │
│  │                             │  │
│  │  [❤]                        │  │  ← Favorite button (top-right)
│  │                             │  │
│  └─────────────────────────────┘  │
│                                   │
│  FEATURED                         │  ← Badge (if highlighted)
│                                   │
│  Modern 3-Bedroom Apartment       │  ← Title (truncate at 2 lines)
│  Marbella, Costa del Sol          │  ← Location
│                                   │
│  €350,000                         │  ← Price (prominent)
│                                   │
│  🛏 3 Beds  🚿 2 Baths  📐 120m²   │  ← Key specs
│                                   │
│  [      View Details      ]       │  ← CTA button
│                                   │
└───────────────────────────────────┘
```

### Property Card (List View)

```
┌────────────────────────────────────────────────────────────────────────────┐
│  ┌─────────────┐                                                           │
│  │             │  Modern 3-Bedroom Apartment                     €350,000  │
│  │             │  Marbella, Costa del Sol                                  │
│  │    IMAGE    │                                                           │
│  │             │  🛏 3 Beds  🚿 2 Baths  📐 120m²  🚗 1 Garage              │
│  │             │                                                           │
│  │     [❤]     │  Stunning apartment with sea views, modern kitchen...    │
│  │             │                                            [View Details] │
│  └─────────────┘                                                           │
└────────────────────────────────────────────────────────────────────────────┘
```

### Filter Dropdown

```
┌─────────────────────────────┐
│ Property Type               │
├─────────────────────────────┤
│ [▼ All Types             ]  │
└─────────────────────────────┘
        │
        ▼
┌─────────────────────────────┐
│ ○ All Types                 │ ← Radio-style, single select
│ ● Apartment                 │
│ ○ Villa                     │
│ ○ Townhouse                 │
│ ○ Penthouse                 │
│ ○ Land                      │
│ ○ Commercial                │
└─────────────────────────────┘
```

### Price Range Slider

```
┌─────────────────────────────────────┐
│ Price Range                         │
├─────────────────────────────────────┤
│                                     │
│  €100,000  ─────────  €500,000      │  ← Current values
│                                     │
│     ●━━━━━━━━━━━━━━━●               │  ← Dual slider
│     │               │               │
│  ───┴───────────────┴───            │
│  €0      €500k      €1M+            │
│                                     │
│  [ Min: €100,000 ] [ Max: €500,000 ]│  ← Input fields
│                                     │
└─────────────────────────────────────┘
```

### Bedroom/Bathroom Selector

```
┌─────────────────────────────────────┐
│ Bedrooms                            │
├─────────────────────────────────────┤
│                                     │
│  [ Any ] [ 1+ ] [ 2+ ] [ 3+ ] [ 4+] │  ← Chip-style selector
│            ▲                        │
│         Selected                    │
│                                     │
└─────────────────────────────────────┘
```

### Feature Checkboxes

```
┌─────────────────────────────────────┐
│ Features                        [▼] │
├─────────────────────────────────────┤
│                                     │
│  ☑ Swimming Pool                    │  ← Checked = filter active
│  ☐ Private Garden                   │
│  ☑ Sea Views                        │
│  ☐ Garage / Parking                 │
│  ☐ Air Conditioning                 │
│  ☐ Terrace / Balcony                │
│                                     │
│  [Show 8 more...]                   │
│                                     │
└─────────────────────────────────────┘
```

---

## URL State Examples

### Empty Search
```
URL: /en/buy
State: All properties for sale
```

### Single Filter
```
URL: /en/buy?type=apartment
State: Apartments for sale
```

### Multiple Filters
```
URL: /en/buy?type=apartment&bedrooms=2&price_max=500000
State: 2+ bed apartments under €500k
```

### Complex Search
```
URL: /en/buy?type=villa&bedrooms=4&bathrooms=3&features=pool,garden,sea-views&zone=costa-del-sol&sort=price-desc
State: 4+ bed, 3+ bath villas in Costa del Sol with pool, garden, sea views, sorted by price high to low
```

### Localized
```
URL: /es/comprar?tipo=apartamento&habitaciones=3
State: 3+ dormitorios apartamentos (Spanish)
```

---

## Interaction Flows

### Filter Change Flow

```
User changes filter
        │
        ▼
┌───────────────────┐
│ Update URL        │ ──→ history.pushState()
│ (pushState)       │
└───────────────────┘
        │
        ▼
┌───────────────────┐
│ Show loading      │ ──→ Skeleton cards OR
│ state             │     Opacity reduction
└───────────────────┘
        │
        ▼
┌───────────────────┐
│ Fetch results     │ ──→ Turbo Frame request
│ (debounced)       │     GET /buy?type=apartment
└───────────────────┘
        │
        ▼
┌───────────────────┐
│ Update results    │ ──→ Turbo replaces frame
│ and map           │     Map controller updates markers
└───────────────────┘
        │
        ▼
┌───────────────────┐
│ Update header     │ ──→ "24 apartments found"
│ (result count)    │
└───────────────────┘
```

### Browser Navigation Flow

```
User clicks back button
        │
        ▼
┌───────────────────┐
│ popstate event    │
│ fires             │
└───────────────────┘
        │
        ▼
┌───────────────────┐
│ Turbo Drive       │ ──→ Fetches previous URL
│ handles nav       │
└───────────────────┘
        │
        ▼
┌───────────────────┐
│ Full page         │ ──→ Server renders with
│ restored          │     URL params applied
└───────────────────┘
        │
        ▼
┌───────────────────┐
│ Filters reflect   │
│ previous state    │
└───────────────────┘
```

---

**Document Version:** 1.0
**Created:** 2024-12-24
