# GraphQL and Advanced Features

> ⚠️ **DEPRECATED**: The GraphQL API is deprecated as of December 2024 and will no longer be actively maintained. New integrations should use the REST API at `/api_public/v1/`. See [app/graphql/DEPRECATED.md](/app/graphql/DEPRECATED.md) for migration guidance. Existing integrations will continue to work but should plan to migrate.

This document provides guidance on integrating your Quasar application with the PropertyWebBuilder GraphQL API and implementing advanced features such as real-time updates and server-side rendering.

## GraphQL Integration

The PropertyWebBuilder API includes a GraphQL endpoint that can be used to query and mutate data. We recommend using [Apollo Client](https://www.apollographql.com/docs/react/) for integrating GraphQL into your Quasar application.

### Setting up Apollo Client

1. **Install the necessary dependencies:**

   ```bash
   npm install --save @apollo/client graphql graphql-tag
   ```

2. **Create a boot file for Apollo Client:**

   **`src/boot/apollo.js`**

   ```javascript
   import { ApolloClient, InMemoryCache, createHttpLink } from '@apollo/client/core';
   import { setContext } from '@apollo/client/link/context';

   const httpLink = createHttpLink({
     uri: 'http://localhost:3000/graphql',
   });

   const authLink = setContext((_, { headers }) => {
     // Get the authentication token from local storage if it exists
     const token = localStorage.getItem('token');
     // Return the headers to the context so httpLink can read them
     return {
       headers: {
         ...headers,
         authorization: token ? `Bearer ${token}` : "",
       }
     }
   });

   const apolloClient = new ApolloClient({
     link: authLink.concat(httpLink),
     cache: new InMemoryCache(),
   });

   export default ({ app }) => {
     app.provide('apollo', apolloClient);
   };
   ```

### Querying and Mutating Data

Once Apollo Client is set up, you can use it to query and mutate data in your components.

```javascript
import { useQuery, useMutation } from '@vue/apollo-composable';
import gql from 'graphql-tag';

// Example query
const { result, loading, error } = useQuery(gql`
  query {
    properties {
      id
      title
    }
  }
`);

// Example mutation
const { mutate: createProperty } = useMutation(gql`
  mutation createProperty($title: String!) {
    createProperty(title: $title) {
      id
      title
    }
  }
`);
```

## Advanced Features

### Real-Time Updates with WebSockets

To implement real-time updates, you can use WebSockets to subscribe to changes in the backend. The PropertyWebBuilder API does not currently include a WebSocket implementation, but this is a feature that could be added in the future.

### Server-Side Rendering (SSR)

Server-side rendering can improve the SEO of your application and provide a better user experience on slow networks. Quasar has built-in support for SSR, which can be enabled in the `quasar.conf.js` file.

```javascript
// quasar.conf.js
module.exports = function (ctx) {
  return {
    ssr: {
      pwa: false,
    },
  };
};
```

Enabling SSR will require some additional configuration and code changes, but it can provide significant benefits for your application.

By leveraging the power of GraphQL and advanced features like SSR, you can build a modern and performant frontend application that provides a great user experience.
