# Seed Images

These images are used for E2E testing and development seeds.

## Source

All images are from [Unsplash](https://unsplash.com) which provides free-to-use images under the [Unsplash License](https://unsplash.com/license).

## Images

| Filename | Property Type | Unsplash Photo ID |
|----------|--------------|-------------------|
| house_family.jpg | Family Home | 1564013799919-ab600027ffc6 |
| apartment_luxury.jpg | Luxury Apartment | 1502672260266-1c1ef2d93688 |
| villa_ocean.jpg | Oceanfront Villa | 1613490493576-7fde63acd811 |
| townhouse_historic.jpg | Historic Townhouse | 1605276374104-dee2a0ed3cd6 |
| apartment_downtown.jpg | Downtown Apartment | 1522708323590-d24dbb6b0267 |
| house_suburban.jpg | Suburban House | 1600596542815-ffad4c1539a9 |
| studio_modern.jpg | Modern Studio | 1560448204-e02f11c3d0e2 |
| penthouse_luxury.jpg | Luxury Penthouse | 1600607687939-ce8a6c25118c |

## Formats

Each image is available in two formats:
- **JPEG** (.jpg) - Primary format, ~60-90 KB each
- **WebP** (.webp) - Modern format, ~30-50% smaller

## Optimization

Images are optimized for web delivery:
- Progressive JPEG encoding
- Compressed to 80-85% quality
- Resized to max 800x533 (property cards) or 1200x800 (detail pages)
- Metadata stripped

To re-optimize after adding new images:
```bash
rails seed_images:optimize
```

See [docs/seeding/seed_image_optimization.md](../../docs/seeding/seed_image_optimization.md) for details.

## Usage

These images are automatically attached to properties during the E2E seed process.
They are stored in the repository to ensure consistent test data across environments.

For external URL mode (production), images are served from R2 CDN.
See [docs/seeding/external_seed_images.md](../../docs/seeding/external_seed_images.md).

## License

The Unsplash License allows:
- Free use for commercial and non-commercial purposes
- No permission needed (though attribution is appreciated)
- Modification and distribution allowed
