require "active_support/core_ext/integer/time"

Rails.application.configure do
  # Settings specified here will take precedence over those in config/application.rb.

  # Make code changes take effect immediately without server restart.
  config.enable_reloading = true

  # Do not eager load code on boot.
  config.eager_load = false

  # Show full error reports.
  config.consider_all_requests_local = true

  # Enable server timing.
  config.server_timing = true

  # Enable/disable Action Controller caching. By default Action Controller caching is disabled.
  # Run rails dev:cache to toggle Action Controller caching.
  if Rails.root.join("tmp/caching-dev.txt").exist?
    config.action_controller.perform_caching = true
    config.action_controller.enable_fragment_cache_logging = true
    config.public_file_server.headers = { "cache-control" => "public, max-age=#{2.days.to_i}" }
  else
    config.action_controller.perform_caching = false
  end

  # Change to :null_store to avoid any caching.
  config.cache_store = :memory_store

  # Store uploaded files on the local file system (see config/storage.yml for options).
  # Use :local for development (reliable), or :cloudflare_r2 for testing CDN integration
  config.active_storage.service = ENV.fetch("ACTIVE_STORAGE_SERVICE", "local").to_sym

  # Email configuration for development
  # By default, emails are opened in browser via letter_opener (if installed)
  # Set SMTP_ADDRESS to test with real email delivery (e.g., Amazon SES)
  config.action_mailer.perform_caching = false

  # Set localhost to be used by links generated in mailer templates.
  config.action_mailer.default_url_options = { host: "localhost", port: 3000 }

  # Development email delivery configuration
  # Option 1: letter_opener gem (default - opens emails in browser)
  # Option 2: SMTP delivery (set SMTP_ADDRESS and unset USE_LETTER_OPENER to enable)
  # Option 3: :test (emails logged but not sent)
  #
  # Set USE_LETTER_OPENER=true to force letter_opener even when SMTP is configured
  #
  if defined?(LetterOpener) && (ENV["USE_LETTER_OPENER"] == "true" || ENV["SMTP_ADDRESS"].blank?)
    # Use letter_opener to preview emails in browser (default in development)
    config.action_mailer.raise_delivery_errors = false
    config.action_mailer.delivery_method = :letter_opener
    # letter_opener stores emails in tmp/letter_opener by default
  elsif ENV["SMTP_ADDRESS"].present?
    # Test with real SMTP (e.g., Amazon SES)
    config.action_mailer.raise_delivery_errors = true
    config.action_mailer.delivery_method = :smtp
    config.action_mailer.smtp_settings = {
      address: ENV["SMTP_ADDRESS"],
      port: ENV.fetch("SMTP_PORT", 587).to_i,
      user_name: ENV["SMTP_USERNAME"],
      password: ENV["SMTP_PASSWORD"],
      domain: ENV.fetch("SMTP_DOMAIN", "localhost"),
      authentication: ENV.fetch("SMTP_AUTH", "login").to_sym,
      enable_starttls_auto: true
    }
  else
    # Default: log emails (not sent)
    config.action_mailer.raise_delivery_errors = false
    config.action_mailer.delivery_method = :test
  end

  # Print deprecation notices to the Rails logger.
  config.active_support.deprecation = :log

  # Raise an error on page load if there are pending migrations.
  config.active_record.migration_error = :page_load

  # Highlight code that triggered database queries in logs.
  config.active_record.verbose_query_logs = true

  # Append comments with runtime information tags to SQL queries in logs.
  config.active_record.query_log_tags_enabled = true

  # Highlight code that enqueued background job in logs.
  config.active_job.verbose_enqueue_logs = true

  # Raises error for missing translations.
  # config.i18n.raise_on_missing_translations = true

  # Annotate rendered view with file names.
  config.action_view.annotate_rendered_view_with_filenames = true

  # Uncomment if you wish to allow Action Cable access from any origin.
  # config.action_cable.disable_request_forgery_protection = true

  # Raise error when a before_action's only/except options reference missing actions.
  config.action_controller.raise_on_missing_callback_actions = true

  # Allow requests from lvh.me and its subdomains for multi-tenant testing
  # lvh.me resolves to 127.0.0.1 and supports subdomains
  config.hosts << ".lvh.me"
  config.hosts << ".dev.localhost"
  config.hosts << "localhost"
  config.hosts << "tenant-a.localhost"
  config.hosts << "tenant-b.localhost"

  # Apply autocorrection by RuboCop to files generated by `bin/rails generate`.
  # config.generators.apply_rubocop_autocorrect_after_generate!

  config.after_initialize do
    Bullet.enable        = true
    Bullet.alert         = false
    Bullet.bullet_logger = true
    Bullet.console       = true
    Bullet.rails_logger  = true
    Bullet.add_footer    = true

    # Safelist for known false positives:
    # PropPhoto => image_attachment is eagerly loaded for ActiveStorage images,
    # but seed data uses external URLs which don't access image_attachment.
    # This is expected behavior - the eager loading is needed for real uploads.
    Bullet.add_safelist type: :unused_eager_loading,
                        class_name: "Pwb::PropPhoto",
                        association: :image_attachment
  end
end
